/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.common.world.gen.feature.structure;

import com.minecraftabnormals.autumnity.core.other.AutumnityLootTables;
import com.minecraftabnormals.autumnity.core.registry.AutumnityBlocks;
import com.minecraftabnormals.autumnity.core.registry.AutumnityStructures;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MapleWitchHutPieces {
    private static final BlockPos STRUCTURE_OFFSET = new BlockPos(0, 0, 0);
    private static final ResourceLocation STRUCTURE = new ResourceLocation("autumnity", "witch_hut/maple_witch_hut");
    private static final ResourceLocation STRUCTURE_OVERGROWN = new ResourceLocation("autumnity", "witch_hut/maple_witch_hut_overgrown");

    public static void func_204760_a(TemplateManager p_204760_0_, BlockPos p_204760_1_, Rotation p_204760_2_, Mirror p_204760_3_, List<StructurePiece> p_204760_4_, Random p_204760_5_) {
        p_204760_4_.add((StructurePiece)new Piece(p_204760_0_, STRUCTURE, p_204760_1_, p_204760_2_, p_204760_3_, 1.0f));
        p_204760_4_.add((StructurePiece)new Piece(p_204760_0_, STRUCTURE_OVERGROWN, p_204760_1_, p_204760_2_, p_204760_3_, 0.2f));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation structure;
        private final Rotation rotation;
        private final Mirror mirror;
        private final float integrity;

        public Piece(TemplateManager templateManager, ResourceLocation templateIn, BlockPos templatePositionIn, Rotation rotationIn, Mirror mirrorIn, float integrityIn) {
            super(AutumnityStructures.Pieces.MAPLE_WITCH_HUT_PIECE, 0);
            this.structure = templateIn;
            this.field_186178_c = templatePositionIn;
            this.rotation = rotationIn;
            this.mirror = mirrorIn;
            this.integrity = integrityIn;
            this.func_204754_a(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT tagCompound) {
            super(AutumnityStructures.Pieces.MAPLE_WITCH_HUT_PIECE, tagCompound);
            this.structure = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.mirror = Mirror.valueOf((String)tagCompound.func_74779_i("Mirror"));
            this.integrity = tagCompound.func_74760_g("Integrity");
            this.func_204754_a(templateManager);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.structure.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
            tagCompound.func_74778_a("Mirror", this.mirror.name());
            tagCompound.func_74776_a("Integrity", this.integrity);
        }

        private void func_204754_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.structure);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(this.mirror).func_207665_a(STRUCTURE_OFFSET).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a).func_215222_a((StructureProcessor)new IntegrityProcessor(this.integrity));
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chest".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tileentity = worldIn.func_175625_s(pos.func_177977_b());
                if (tileentity instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity).func_189404_a(AutumnityLootTables.CHESTS_MAPLE_WITCH_HUT, rand.nextLong());
                }
            } else if ("decor".equals(function)) {
                if (rand.nextInt(2) == 0) {
                    worldIn.func_180501_a(pos, Blocks.field_196756_ey.func_176223_P(), 2);
                } else {
                    worldIn.func_180501_a(pos, Blocks.field_196757_ez.func_176223_P(), 2);
                }
            } else if ("flower".equals(function)) {
                if (rand.nextInt(4) == 0) {
                    worldIn.func_180501_a(pos.func_177977_b(), ((Block)AutumnityBlocks.AUTUMN_CROCUS.get()).func_176223_P(), 2);
                }
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            } else if (function.startsWith("witch")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                WitchEntity witchentity = (WitchEntity)EntityType.field_200759_ay.func_200721_a((World)worldIn.func_201672_e());
                witchentity.func_110163_bv();
                witchentity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 1.0, (double)pos.func_177952_p() + 0.5);
                witchentity.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
                worldIn.func_242417_l((Entity)witchentity);
            } else if (function.startsWith("cat")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                CatEntity catentity = (CatEntity)EntityType.field_220360_g.func_200721_a((World)worldIn.func_201672_e());
                catentity.func_110163_bv();
                catentity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 1.0, (double)pos.func_177952_p() + 0.5);
                catentity.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
                catentity.func_213422_r(10);
                worldIn.func_242417_l((Entity)catentity);
            }
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }
    }
}

